<report title="D2D - EMR DQ Depression Coded Denom v1" description="Lists patients with possible depression diagnosis."
active="1">
<query>

SELECT DISTINCT d.demographic_no Demographic, d.sex Sex, floor(datediff(curdate(),str_to_date(concat(d.year_of_birth,d.month_of_birth,d.date_of_birth),'%Y%m
%d'))/365.25) Age, concat(d.last_name, ', ', d.first_name) Patient, concat(p.last_name, ', ', p.first_name) MRP
FROM demographic d

INNER JOIN provider p
    ON d.provider_no = p.provider_no
    AND p.provider_no = {provider_no}

LEFT JOIN dxresearch dx
    ON d.demographic_no = dx.demographic_no

LEFT JOIN drugs dr
    ON d.demographic_no = dr.demographic_no
    
LEFT JOIN measurements m
    ON d.demographic_no = m.demographicNo

WHERE 
    d.patient_status = 'AC' 
    AND 
    (
        # Search Problem List
        (
            # Inclusion
            (dx.dxresearch_code IN ('2962', '2963', '2964', '3004', '311', 'F320', 'D9-52') 
            AND dx.status = "A")
            # Exclusion
            AND (NOT (dx.dxresearch_code IN ('295', '2966', '2967', '2968', 'F200', 'F310') AND dx.status = "A")
                OR dx.dxresearch_code is NULL)
        )
        # Search Medications
        OR (
            # Inclusion
            dr.GN RLIKE 'citalopram|fluoxetine|sertraline|paroxetine|duloxetine|venlafaxine|trazodone'
            AND dr.end_date >= curdate()
            # Exclusion
            AND (NOT (dx.dxresearch_code IN ('3000', '30000', '30001', 'F410') AND dx.status = "A")
                OR dx.dxresearch_code IS NULL)
        ) OR (
            # Inclusion
            dr.GN LIKE '%bupropion%' 
            AND dr.end_date >= curdate()
            # Exclusion
            AND (NOT (
                    (m.type IN ('SKST', 'SMK', 'SMKS') AND m.dataField RLIKE 'y|current')
                    OR
                    (dx.dxresearch_code = '3051' AND dx.status = "A")
                )
                OR m.type IS NULL)
        )
    )
ORDER by d.last_name;

</query>
<param id="provider_no" type="list" description="Provider Number">
<param-query> 
	select provider_no, concat(last_name,',',first_name,'(',provider_no,')') from provider 
	order by last_name; 
</param-query>
</param>

</report>